﻿<?LassoScript
	/*
			This page lists all of the users who have blogs. If the user is
		logged in and has previously initialized their blog, then the New Blog
		Entry form is shown. If the user is logged in and has not initialized
		their blog, then the blog initialization form is shown.
	*/
	'<div class="group_list">\
		<div class="group">\
			<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
			<div class="group_title">\
				Blog Authors\
			</div>';
			local('authorFilter'=null);
			local('hasBlog' = false);
			if ($isLoggedIn); // this page variable is set in ../library.lasso
			
				local(	'blogId' = 0,
						// these next three action_params are present if the user is initializing their blog for the first time
						'newBlog' = action_param('newBlog'),
						'blogTitle' = action_param('blogTitle'), 
						'blogDesc' = action_param('blogDesc'));
						
				// find the current user's author id
				inline(-database='op_blog', -table='blogs', -op='eq', 'author'=admin_currentusername,
						-returnField='title', -returnField='id', -search);
					if(!found_count); // if the user is not found, then they have never initialized their blog
						if (#newBlog); // creating a new blog?
							inline(-add, 'author'=admin_currentusername, 'title'=#blogTitle, 'description'=#blogDesc);
								#hasBlog = true;
								inline(-search, -op='eq', 'author'=admin_currentusername,
										-returnField='title', -returnField='id');	
									// alter the authorFilter so that the user is not shown in the main list
									#authorFilter = array(-op='neq', 'id'=field('id'));
									// save the id and title
									#blogId = field('id');
									#blogTitle = field('title');
								/inline;
							/inline;
						/if;
					else; // else the user has a blog
						#hasBlog = true;
						// alter the authorFilter so that the user is not shown in the main list
						#authorFilter = array(-op='neq', 'id'=field('id'));
						// save the id and title
						#blogId = field('id');
						#blogTitle = field('title');
					/if;
				/inline;
				if (#hasBlog);
				// if the user has a blog, show them at the top and do not list them in the regular user list
				'<div class="item">\
					<div class="item_title"><a href="'Application_appInfo->indexFile'?list='admin_currentusername'">YOU</a></div>
					<div class="item_description">'#blogTitle'</div>\
					<div class="item_details">';
					inline(-database='op_blog', -table='entries', -op='eq', 'id_blog'=#blogId, -search, 
							-returnField='date', -returnField='title', -sortField='date', -sortOrder='descending', -maxrecords=1);
						found_count + (found_count == 1? ' Entry' | ' Entries');
						found_count? (' - Last entry: 'field('title')' ('field('date')')');
					/inline;
					'</div>\
				</div>';
				/if;
			/if;
			// find all the blog authors, ommiting the current user if applicable
			inline(-database='op_blog', -table='blogs', #authorFilter, -search);
				records;
				'<div class="item">\
					<div class="item_title"><a href="'Application_appInfo->indexFile'?list='field('author')'">'field('title')'</a> by <i>'encode_html(field('author'))'</i></div>
					<div class="item_description">'encode_html(field('description'))'</div>\
					<div class="item_details">';
					// find the total number of entries and the title and date of the last entry
					inline(-table='entries', -op='eq', 'id_blog'=field('id'), -search, 
							-returnField='date', -returnField='title', -sortField='date', -sortOrder='descending', -maxrecords=1);
						found_count + (found_count == 1? ' Entry' | ' Entries');
						found_count? (' - Last entry: 'field('title')' ('field('date')')');
					/inline;
					'</div>\
				</div>';
				/records;
			/inline;
			
		'</div>';
		if ($isLoggedIn);
			'<div class="group">\
			<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>';
			if (!#hasBlog);
			// if the user is logged in, but has never initialized their blog, display the blog initialization form
			'<div class="group_title">Create Your Blog</div>\
			<div class="item">\
				<form method="POST" action="'Application_appInfo->indexFile'">\
					Blog Name<br />\
					<input type="text" name="blogTitle" size="50" value="" /><br />\
					Blog Description<br />\
					<textarea name="blogDesc" style="width: 80%; height: 100px"></textarea><br />\
					<input type="submit" value="Create" name="newBlog" />\
				</form>\
			</div>';
			else;
			// else display the new blog post form
			// this form is handled by the entry_list.lasso page
			'<div class="group_title">Post New Blog Entry</div>\
				<div class="item">\
					<form method="POST" action="'Application_appInfo->indexFile'">\
						<input type="hidden" name="list" value="'admin_currentusername'" />\
						Entry Title<br />\
						<input type="text" name="postTitle" size="50" value="" /><br />\
						Entry Text<br />\
						<textarea name="postBody" style="width: 80%; height: 100px"></textarea><br />\
						<input type="submit" value="Post New Entry" name="newPost" />\
					</form>\
				</div>\
			</div>';
			/if;
			'</div>';
		/if;
	'</div>';
?>